/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

#include <opencv2/opencv.hpp>
#include <umat.hpp>
#include <iostream>
#include <ostream>

#include "../../A53_gen/inc/apu_roiicp0_process_controller.hpp"

using namespace cv;
using namespace std;
using namespace apugen;

APU_RoiIcp0_Process_Controller::APU_RoiIcp0_Process_Controller(int32_t apex_id) {
#ifdef APEX2_EMULATE
	pProc = new ROIICP_PI((APEX_ID)apex_id);
#else 
	pProc = new ROIICP_PI(apex_id);
#endif
}

APU_RoiIcp0_Process_Controller::~APU_RoiIcp0_Process_Controller() {
	delete pProc;
}

int32_t APU_RoiIcp0_Process_Controller::Init() {
	int32_t lRetVal = 0;
	lRetVal |= pProc->Initialize();

	return lRetVal;
}

int32_t APU_RoiIcp0_Process_Controller::Connect(vsdk::UMat& dataInput0, cv::Rect& rectRoi_Input0, vsdk::UMat& dataOutput0, cv::Rect& rectRoi_Output0) {
int32_t lRetVal = 0;
lRetVal |= pProc->ConnectIO_ROI(GR_INPUT0_IN, dataInput0, rectRoi_Input0.x, rectRoi_Input0.y, rectRoi_Input0.width, rectRoi_Input0.height);
lRetVal |= pProc->ConnectIO_ROI(GR_OUTPUT0_OUT, dataOutput0, rectRoi_Output0.x, rectRoi_Output0.y, rectRoi_Output0.width, rectRoi_Output0.height);


	return lRetVal;
}

int32_t APU_RoiIcp0_Process_Controller::Start() {
	return pProc->Start();
}

int32_t APU_RoiIcp0_Process_Controller::Wait() {
	return pProc->Wait();
}

